﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace Malefiz
{
    public class Spieler
    {
        /// <summary>
        /// In dieser Eigenschaft wird der Name dieses Spielers gespeichert.
        /// </summary>
        public string Spielername { get; set; }

        private int spielernummer;

        /// <summary>
        /// In dieser Eigenschaft wird die Nummer dieses Spielers gespeichert:
        /// 0: Roter Spieler
        /// 1: Grüner Spieler
        /// 2: Gelber Spieler
        /// 3: Blauer Spieler
        /// Wird sie verändert, wird automatisch das Porträt des Spielers angepasst.
        /// </summary>
        public int Spielernummer
        {
            get { return spielernummer; }
        }

        private Image spielerporträt;

        /// <summary>
        /// In dieser Eigenschaft kann das Porträtbild dieses Spielers ausgelesen werden.
        /// Es wird zur Initialisierung bereits automatisch dem Spieler zugeordet und darf anschließend 
        /// nicht mehr verändert werden.
        /// </summary>
        public Image Spielerporträt
        {
            get { return spielerporträt; }
        }

        /// <summary>
        /// Wenn der Spieler gerade eine Barrikade versetzen darf so soll diese Eigenschaft auf true gesetzt werden.
        /// Zur Initialisierung wird diese Eigenschaft automatisch auf false gesetzt.
        /// </summary>
        public bool HatBarrikade { get; set; }

        /// <summary>
        /// In dieser Eigenschaft ist die Nummer der Barrikade gespeichert, die der Spieler gerade versetzen darf: 
        /// 0: Barrikade 1 ... 10: Barrikade 11
        /// Ob der Spieler derzeit überhaupt eine Barrikade versetzen darf, ist in der boolschen Eigenschaft HatBarrikade gespeichert.
        /// </summary>
        public int Barrikadennummer { get; set; }

        
        
        //Konstruktoren
        public Spieler()
        {
            HatBarrikade = false;
        }

        /// <summary>
        /// Erstellt einen neuen Spieler. Anhand der Spielernummer wird diesem Spieler automatisch das richtige 
        /// Spielerporträt zugewiesen. Die Spielernummer sowie das Spielerporträt kann anschließend nicht mehr 
        /// verändert werden.
        /// Voreinstellung: 
        /// HatBarrikade = false
        /// </summary>
        /// <param name="spielername">Der Name dieses Spielers</param>
        /// <param name="_spielernummer">Die Spielernummer:
        /// 0: Roter Spieler
        /// 1: Grüner Spieler
        /// 2: Gelber Spieler
        /// 3: Blauer Spieler</param>
        public Spieler(string spielername, int _spielernummer) : this()
        {
            Spielername = spielername;
            spielernummer = _spielernummer;

            if (_spielernummer == 0)
            { spielerporträt = pictures.Spieler_1; }
            if (_spielernummer == 1)
            { spielerporträt = pictures.Spieler_2; }
            if (_spielernummer == 2)
            { spielerporträt = pictures.Spieler_3; }
            if (_spielernummer == 3)
            { spielerporträt = pictures.Spieler_4; }
        }
    }
}